#!/bin/bash

# 提取 server URL
server_url=$(kubectl config view 2>&1 | grep -E '^\s*server:\s*http' | sed -E 's/^\s*server:\s*//')

# 验证 server_url 是否存在
if [[ -z "$server_url" ]]; then
    echo "Error: Missing 'server' field in kubeconfig" >&2
    exit 1
fi

# 提取 zoneID（从 vcluster. 后的第一个字段）
zoneID=$(echo "$server_url" | cut -d. -f2)  # 使用 cut 按点分割取第二部分[1,8](@ref)

# 提取 vksID（inCluster/ 后的部分）
vksID=$(echo "$server_url" | awk -F '/inCluster/' '{print $2}' | cut -d/ -f1)  # 二次分割确保精确[2](@ref)

# 验证提取结果
if [[ -z "$zoneID" ]]; then
    echo "Error: Failed to extract zone-id from URL" >&2
    echo "Expected format: https://vcluster.<zone-id>.alayanew.com:21443/inCluster/<vks-id>" >&2
    echo "Actual URL: $server_url" >&2
    exit 1
fi

if [[ -z "$vksID" ]]; then
    echo "Error: Failed to extract cluster-id from URL" >&2
    echo "Expected format: https://vcluster.<zone-id>.alayanew.com:21443/inCluster/<vks-id>" >&2
    echo "Actual URL: $server_url" >&2
    exit 1
fi

# 输出结果
echo "zoneID: $zoneID"
echo "vksID: $vksID"

# 执行 Helm 安装命令
helm install devtron . \
    --create-namespace \
    -n devtroncd \
    --values resources.yaml \
    --set "zoneID=$zoneID" \
    --set "vksID=$vksID" \
    --set "global.containerRegistry=registry.${zoneID}.alayanew.com:8443/vc-app_market/devtron"