## 应用概述
ComfyUI 是一个基于人工智能的图像生成工具，专注于通过直观的用户界面和强大的功能帮助用户创建高质量的艺术作品。它通常与 Stable Diffusion 等图像生成模型结合使用，提供了一种简便的方式来生成、编辑和管理图像。

serverless-comfyui 是基于kubeai实现的一种comfyui自动扩缩容推理服务。 访问comfyui的接口，经过kubeai代理，当长时间没有接口调用时，自动缩容comfyui的容器。当有新的接口调用，经过kubeai的代理，kubeai根据配置，自动启动comfyui的推理容器。

目前该chart的comfyui镜像只安装了Janus-Pro-7B模型的插件，只支持Janus-Pro-7B模型


## 应用配置

```yaml
# 应用名称
appName: serverless-comfyui 

# 开通的弹性容器集群的ID，通过如下命令获取  kubectl cluster-info | awk -F'/' '{print $NF}' | head -n 1
vksID: vcacu2dshr12

model: 
  # comfyui的镜像
  image: registry.hd-01.alayanew.com:8443/vc-app_market/comfyui:pytorch2.6-cuda124-root-0.0.1
  # comfyui的容器挂载目录，目前只支持名称为 pvc-capacity-userdata 的PVC挂载
  # 挂载数据尽量提前准备好，不要在容器启动时下载
  # name 可随意填写(但必填)，默认只挂载PVC: pvc-capacity-userdata
  volumeMounts:
    - name: userdata-pvc  
      mountPath: /app/models # 镜像启动的容器内目录
      subPath: apps/comfyui-janus-pro-7b/models # PVC:pvc-capacity-userdata 下的相对目录
    - name: userdata-pvc 
      mountPath: /app/output
      subPath: apps/comfyui-janus-pro-7b/output
    - name: userdata-pvc 
      mountPath: /app/input
      subPath: apps/comfyui-janus-pro-7b/input

  # GPU资源，您开通VKS集群的GPU标签，不包含 `nvidia.com/` 部分    
  resourceProfile: gpu-h100-80gb-hbm3:1
  minReplicas: 0 # 最小副本数，设置为0 ，长时间没有调用推理，则停止容器
  maxReplicas: 1 # 最大副本数，comfyui 设置为 1

  # TargetRequests is average number of active requests that the autoscaler
  # will try to maintain on model server Pods.
  # +kubebuilder:validation:Minimum=1
  # +kubebuilder:default=100
  targetRequests: 5 


  # ScaleDownDelay is the minimum time before a deployment is scaled down after
  # the autoscaling algorithm determines that it should be scaled down.
  # +kubebuilder:default=30
  scaleDownDelaySeconds: 30
```
为了实现当没有接口调用时，自动停止comfyui的推理容器，需要将  
Values.model.minReplicas设置为0。  
Values.model.maxReplicas 设置为1  

## 访问comfyui

### 访问comfyui的接口  
    为了实现没有接口调用时，自动停止comfyui的推理容器，所有访问comfyui的接口调用，都会经过kubeai代理。    
    因此，当调用comfyui接口时，使用如下方式：  
        {namespace}: 替换成您实际的命名空间    
        {vksID}: values.yaml中的vksID      
    
        首先获取kubeai的url， 如下:   
        https://kubeai-x-{namespace}-x-{vksID}.sproxy.hd-01.alayanew.com:22443/openai   
    
        其次，拼接comfyui的接口path，如获取comfyui的状态接口：  
        path: /api/system_stats   
        则实际的访问url如下：  
        https://kubeai-x-{namespace}-x-{vksID}.sproxy.hd-01.alayanew.com:22443/openai/api/system_stats   
          
        然后，任何接口调用请求，都需要请求体body，且body体内必填model参数，参数值是 Values.appName    
        如本示例body体的结构是如下json:  
        ```json
        {
            "model": "serverless-comfyui"
        }
        ```

    示例 调用comfyui获取系统状态接口：  
    ```shell
        curl -m 300 -X GET https://kubeai-x-kbi-x-vcacu2dshr12.sproxy.hd-01.alayanew.com:22443/openai/api/system_stats \
        -d '{
                "model": "serverless-comfyui"
            }'
    ```  
    **注意**：  
        当Values.model.minReplicas设置为0时，不会自动启动comfyui的容器，需要一次接口调用触发启动容器。   
        因此第一次调用需要设置稍长的超时时间，或者做好重试机制    

### 页面访问comfyui  
    本应用同样提供comfyui的页面访问方式，页面url地址如下：   
    {appName}: values.yaml中的appName   
    {namespace}: 替换成您实际的命名空间      
    {vksID}: values.yaml中的vksID    

    https://{appName}-x-{namespace}-x-{vksID}.sproxy.hd-01.alayanew.com:22443  

    **注意**：  
        因为comfyui默认不自动启动，如果要页面访问comfyui，需要首先按第一步，调用一次comfyui的接口，触发comfyui的推理容器启动   


通过私有应用市场部署该应用时，上述地址可通过NOTES.txt文件，直接获取